<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_ai_models', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('provider'); 
            $table->string('model_name')->nullable();
            $table->string('api_key')->nullable();
            $table->string('base_url')->nullable();
            $table->json('headers')->nullable();
            $table->json('params')->nullable();
            $table->json('payload')->nullable();
            $table->boolean('is_default')->default(false);
            $table->text('description')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_ai_models');
    }
};